<?php
/*
Plugin Name: Gswitcher - Custom Language Switcher for TranslatePress
Description: A Custom language switcher for TranslatePress
Version: 1.0.0
Author: George Statis
License: GPL2
*/


add_action('wp_enqueue_scripts', 'gswitcher_enqueue_style');
function gswitcher_enqueue_style(){
    wp_enqueue_style('gswitcher', plugin_dir_url(__FILE__) . 'gswitcher.css', [], '1.0.0');
}


//[gswitcher]
function gswitcher_func( $atts ){
    global $TRP_LANGUAGE;
    $trp = TRP_Translate_Press::get_trp_instance();    
    $settings = $trp->get_component("settings")->get_settings();
    $trp_languages = $trp->get_component( 'languages' );
    $url_converter = $trp->get_component( 'url_converter' );
    
    if ( current_user_can(apply_filters( 'trp_translating_capability', 'manage_options' )) ){
        $languages_to_display = $settings['translation-languages'];
    }else{
        $languages_to_display = $settings['publish-languages'];
    }

    $published_languages = $trp_languages->get_language_names( $languages_to_display );


    $ret="<div class='gswitcher'>";
    foreach( $published_languages as $code => $name ) {
        
        $language_url= esc_url( $url_converter->get_url_for_language($code, false) ); 
        $language_label = strtoupper( $url_converter->get_url_slug( $code,  false ) );
        //var_dump($url, $current_language_label);
        if($code==$TRP_LANGUAGE){
            $ret.="<a class='gswitcher-lang-item active' href='".$language_url."'>".$language_label."</a>";            
        } else {
            $ret.="<a class='gswitcher-lang-item' href='".$language_url."'>".$language_label."</a>";            
        }       
    }
    $ret.="</div>";
	return $ret;
}

add_shortcode( 'gswitcher', 'gswitcher_func' );
